/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class ClusterConfigFileReader
implements OiilQuery {
    private static final int INVALID_FILE_NAME = 20000;
    private static final int FILE_DOES_NOT_EXIST = 20001;
    private static final int DIRECTORY_MENTIONED = 20002;
    private static final int SECURITY_EXCEPTION = 20003;
    private static final int FILE_NOT_FOUND_EXCEPTION = 20004;
    private static final int IO_EXCEPTION = 20005;
    private static final int FILE_NOT_READABLE_EXCEPTION = 20006;
    private static final int THROWABLE_ERROR = 20007;
    private static final int NO_INFORMATION_RETRIEVED = 20008;
    private static final int PUBNODE_NOTFOUND_EXCEPTION = 20009;
    private static final int PRIVNODE_MISMATCH_EXCEPTION = 20010;
    private static final int INVALID_NODE_NAMES_EXCEPTION = 20011;
    private static final int INVALID_NODE_NAMES_GENERAL_ERROR = 20012;
    private static final int NO_9IRAC_FOUND = 20013;
    private static final int CLUSTER_NAME_NOT_SPECIFIED = 20014;
    private static final String[][] ERROR_MESSAGE = new String[][]{{"20000", OiQueryFileRes.getString("OiClusterConfigFileInput_INVALID_FILE_NAME")}, {"20001", OiQueryFileRes.getString("OiClusterConfigFileInput_FILE_DOES_NOT_EXIST")}, {"20002", OiQueryFileRes.getString("OiClusterConfigFileInput_DIRECTORY_MENTIONED")}, {"20003", OiQueryFileRes.getString("OiClusterConfigFileInput_SECURITY_EXCEPTION")}, {"20004", OiQueryFileRes.getString("OiClusterConfigFileInput_FILE_NOT_FOUND_EXCEPTION")}, {"20005", OiQueryFileRes.getString("OiClusterConfigFileInput_IO_EXCEPTION")}, {"20006", OiQueryFileRes.getString("OiClusterConfigFileInput_FILE_NOT_READABLE_EXCEPTION")}, {"20007", OiQueryFileRes.getString("OiClusterConfigFileInput_THROWABLE_ERROR")}, {"20008", OiQueryFileRes.getString("OiClusterConfigFileInput_NO_INFORMATION_RETRIEVED")}, {"20009", OiQueryFileRes.getString("OiClusterConfigFileInput_PUBNODE_NOTFOUND_EXCEPTION")}, {"20010", OiQueryFileRes.getString("OiClusterConfigFileInput_PRIVNODE_MISMATCH_EXCEPTION")}, {"20011", OiQueryFileRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_EXCEPTION")}, {"20012", OiQueryFileRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_GENERAL_ERROR")}, {"20013", OiQueryFileRes.getString("OiClusterConfigFileInput_NO_9IRAC_FOUND")}, {"20014", OiQueryFileRes.getString("OiClusterConfigFileInput_CLUSTER_NAME_NOT_SPECIFIED")}};
    private boolean isVendorCluster = false;
    private String[] currentSpreadTable = null;
    private String[] nodeListFromAPI = null;
    private String configFileName = null;
    private String clusterName = null;
    private String[] fillSpreadTable = null;

    public Object performQuery(Vector inputs) throws OiilQueryException {
        String[] retVal = null;
        this.isVendorCluster = (Boolean)this.retItem(inputs, "isVendorCluster");
        this.currentSpreadTable = (String[])this.retItem(inputs, "currentSpreadTable");
        this.nodeListFromAPI = (String[])this.retItem(inputs, "nodeListFromAPI");
        this.configFileName = (String)this.retItem(inputs, "configFileName");
        String[][] nodeList = this.populateNodes(this.configFileName);
        if (this.evaluateNodes(nodeList)) {
            retVal = this.fillSpreadTable;
        } else {
            System.out.println("Installer will Abort Installation ");
            nodeList = new String[1][1];
            nodeList[0][0] = "ERROR";
            retVal = nodeList[0];
        }
        return retVal;
    }

    public String[][] populateNodes(String configFile) {
        String[][] resultStr = new String[1][1];
        resultStr[0][0] = "ERROR0:20008";
        String curLine = null;
        Vector<String> vectorObj = new Vector<String>();
        String[] tempString = null;
        int rowCounter = 0;
        try {
            if (configFile == null || configFile.trim().length() == 0) {
                resultStr[0][0] = "ERROR0:20000";
                return resultStr;
            }
            File fileObj = new File(configFile);
            if (!fileObj.exists()) {
                resultStr[0][0] = "ERROR0:20001";
                return resultStr;
            }
            if (fileObj.isDirectory()) {
                resultStr[0][0] = "ERROR0:20002";
                return resultStr;
            }
            if (!fileObj.isFile()) {
                resultStr[0][0] = "ERROR0:20000";
                return resultStr;
            }
            if (!fileObj.canRead()) {
                resultStr[0][0] = "ERROR0:20006";
                return resultStr;
            }
            FileInputStream fileInputStreamObj = new FileInputStream(configFile);
            BufferedReader bufReaderObj = new BufferedReader(new InputStreamReader(fileInputStreamObj));
            int indexCounter = 0;
            boolean clusterNameParsed = false;
            while ((curLine = bufReaderObj.readLine()) != null) {
                if ((curLine = curLine.trim()).startsWith("#") || curLine.length() == 0 || (tempString = curLine.split("\\s+")) == null) continue;
                if (!clusterNameParsed) {
                    vectorObj.add(indexCounter++, curLine);
                    System.setProperty("install.crs.ccf.clustername", curLine);
                    clusterNameParsed = true;
                } else if (tempString.length < 3) {
                    if (tempString.length == 1) {
                        vectorObj.add(indexCounter++, tempString[0]);
                        vectorObj.add(indexCounter++, "");
                        vectorObj.add(indexCounter++, "");
                    } else {
                        vectorObj.add(indexCounter++, tempString[0]);
                        vectorObj.add(indexCounter++, tempString[1]);
                        vectorObj.add(indexCounter++, "");
                    }
                } else if (tempString.length >= 3) {
                    for (int i = 0; i < 3; ++i) {
                        if (tempString[i] == null || tempString[i].trim().length() == 0) continue;
                        vectorObj.add(indexCounter++, tempString[i]);
                    }
                }
                vectorObj.add(indexCounter++, "END_OF_LINE");
                ++rowCounter;
            }
            if (rowCounter != 0) {
                resultStr = new String[rowCounter][];
                String tempVal = null;
                Vector<String> tempVector = null;
                int vectorIndex = 0;
                for (int i = 0; i < rowCounter; ++i) {
                    int k = 0;
                    tempVector = new Vector<String>();
                    while (!(tempVal = (String)vectorObj.elementAt(vectorIndex)).equals("END_OF_LINE")) {
                        tempVector.add(k++, tempVal);
                        ++vectorIndex;
                    }
                    ++vectorIndex;
                    resultStr[i] = new String[tempVector.size()];
                    for (int j = 0; j < tempVector.size(); ++j) {
                        resultStr[i][j] = (String)tempVector.elementAt(j);
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            resultStr = new String[1][1];
            resultStr[0][0] = "ERROR0:20004:" + fnfe.getMessage();
            return resultStr;
        }
        catch (SecurityException se) {
            resultStr = new String[1][1];
            resultStr[0][0] = "ERROR0:20003:" + se.getMessage();
            return resultStr;
        }
        catch (IOException ie) {
            resultStr = new String[1][1];
            resultStr[0][0] = "ERROR0:20005:" + ie.getMessage();
            return resultStr;
        }
        catch (Throwable t) {
            resultStr = new String[1][1];
            resultStr[0][0] = "ERROR0:20007:" + t.getMessage();
            return resultStr;
        }
        return resultStr;
    }

    public boolean evaluateNodes(String[][] nodeList) {
        boolean areNodesValid = false;
        int lenOutput = nodeList.length;
        if (nodeList[0][0].startsWith("ERROR0")) {
            int errorCode = Integer.parseInt(nodeList[0][0].split(":", 2)[1]);
            return this.handleFileError(errorCode);
        }
        this.setClusterName(nodeList[0][0]);
        this.fillSpreadTable = new String[nodeList.length - 1];
        for (int i = 1; i < nodeList.length; ++i) {
            this.fillSpreadTable[i - 1] = !this.isVendorCluster ? nodeList[i][0] + ":" + nodeList[i][1] + ":" + nodeList[i][2] + ":" + "N:Y" : nodeList[i][0] + ":" + nodeList[i][1] + ":" + nodeList[i][2] + ":" + "N:Y";
        }
        if (this.isVendorCluster) {
            this.fillSpreadTable = this.validateNodeNames(this.fillSpreadTable);
            if (this.fillSpreadTable[0].startsWith("ERROR1")) {
                return this.handleFileError(this.fillSpreadTable[0].split(":", 2)[1]);
            }
            if (this.fillSpreadTable[0].startsWith("ERROR2")) {
                String errorMessage = null;
                String unavailablePublicNodes = "";
                String invalidPubPrivNodes = "";
                for (int i = 0; i < this.fillSpreadTable.length; ++i) {
                    if (this.fillSpreadTable[i].split(":", 3)[1].equals("20009")) {
                        unavailablePublicNodes = unavailablePublicNodes + this.fillSpreadTable[i].split(":", 3)[2] + " ";
                        continue;
                    }
                    invalidPubPrivNodes = invalidPubPrivNodes + this.fillSpreadTable[i].split(":", 3)[2] + " ";
                }
                errorMessage = OiQueryFileRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_GENERAL_ERROR");
                errorMessage = errorMessage + "\n\n";
                if (unavailablePublicNodes.trim().length() != 0) {
                    errorMessage = errorMessage + OiQueryFileRes.getString("OiClusterConfigFileInput_PUBNODE_NOTFOUND_EXCEPTION");
                    errorMessage = errorMessage + "\n";
                    errorMessage = errorMessage + "\t" + unavailablePublicNodes;
                    errorMessage = errorMessage + "\n";
                }
                if (invalidPubPrivNodes.trim().length() != 0) {
                    errorMessage = errorMessage + OiQueryFileRes.getString("OiClusterConfigFileInput_PRIVNODE_MISMATCH_EXCEPTION");
                    errorMessage = errorMessage + "\n";
                    errorMessage = errorMessage + "\t" + invalidPubPrivNodes;
                    errorMessage = errorMessage + "\n";
                }
                errorMessage = errorMessage + OiQueryFileRes.getString("OiClusterConfigFileInput_CORRECTIVE_ACTION");
                return this.handleFileError(errorMessage);
            }
            if (this.fillSpreadTable[0].startsWith("ERROR3")) {
                return this.handleFileError(this.fillSpreadTable[0].split(":", 2)[1]);
            }
            areNodesValid = true;
        } else {
            String localNode = this.nodeListFromAPI[0].split(":")[0];
            for (int i = 0; i < this.fillSpreadTable.length; ++i) {
                String currentPubNodeFromFile = this.fillSpreadTable[i].split(":")[0];
                try {
                    InetAddress inetObjLocalNodeFromAPI = InetAddress.getByName(localNode);
                    InetAddress inetObjLocalNodeFromFile = InetAddress.getByName(currentPubNodeFromFile);
                    String localNodeFromAPI_IP = inetObjLocalNodeFromAPI.getHostAddress();
                    String localNodeFromFile_IP = inetObjLocalNodeFromFile.getHostAddress();
                    if (!localNodeFromAPI_IP.equalsIgnoreCase(localNodeFromFile_IP)) continue;
                    areNodesValid = true;
                    break;
                }
                catch (UnknownHostException unkhe) {
                    String errorText = "Exception Occurred while comparing the localNode from install flow:" + localNode + " and " + "the localNode retrieved from the CCF file:" + currentPubNodeFromFile;
                    OiiolTextLogger.appendText((String)errorText);
                    OiiolTextLogger.appendText((String)unkhe.getMessage());
                }
            }
            if (!areNodesValid) {
                String message = OiQueryFileRes.getString("OiClusterConfigFileInput_LOCAL_NODE_MISSING_EXCEPTION");
                return this.handleFileError(message);
            }
        }
        return areNodesValid;
    }

    private boolean handleFileError(String errorMessage) {
        System.out.println(errorMessage);
        return false;
    }

    private boolean handleFileError(int errorCode) {
        String currentErrorMessage = "";
        for (int i = 0; i < ERROR_MESSAGE.length; ++i) {
            if (errorCode != Integer.parseInt(ERROR_MESSAGE[i][0])) continue;
            currentErrorMessage = ERROR_MESSAGE[i][1];
            break;
        }
        System.out.println(currentErrorMessage);
        return false;
    }

    public void setClusterName(String cluster) {
        this.clusterName = cluster;
    }

    public Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public String[] validateNodeNames(String[] listReadFromFile) {
        Vector<String> inValidNodeVector = new Vector<String>();
        Vector<String> inValidPubNodesFromSpreadTable = new Vector<String>();
        Vector<String> inValidPubNodesFromFile = new Vector<String>();
        int idx = 0;
        int count9iRACNodesFromAPI = 0;
        boolean areFileNodesSubset = true;
        boolean areAllNodes9i = false;
        boolean comboCase = false;
        Vector<String> pickUp9iNodesFromSpreadTable = new Vector<String>();
        if (this.currentSpreadTable != null) {
            int i;
            for (i = 0; i < listReadFromFile.length; ++i) {
                if (listReadFromFile[i] == null) continue;
                inValidPubNodesFromFile.add(i, listReadFromFile[i].split(":")[0]);
            }
            for (i = 0; i < this.currentSpreadTable.length; ++i) {
                if (this.currentSpreadTable[i] == null) continue;
                inValidPubNodesFromSpreadTable.add(i, this.currentSpreadTable[i].split(":")[0]);
                if (!this.currentSpreadTable[i].split(":")[3].equalsIgnoreCase("Y")) continue;
                pickUp9iNodesFromSpreadTable.add(count9iRACNodesFromAPI, this.currentSpreadTable[i].split(":")[0]);
                ++count9iRACNodesFromAPI;
            }
            if (count9iRACNodesFromAPI == this.currentSpreadTable.length) {
                areAllNodes9i = true;
            }
            if (count9iRACNodesFromAPI > 0 && !areAllNodes9i) {
                comboCase = true;
            }
            if (count9iRACNodesFromAPI == 0) {
                // empty if block
            }
            if (listReadFromFile != null) {
                int i2;
                int counter;
                if (listReadFromFile.length > this.currentSpreadTable.length) {
                    areFileNodesSubset = false;
                    listReadFromFile = new String[]{"ERROR1:" + OiQueryFileRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_EXCEPTION")};
                    return listReadFromFile;
                }
                String curSpreadTablePubNode = null;
                String curSpreadTablePrivNode = null;
                String curPubNode = null;
                String curPrivNode = null;
                String[] tempArray1 = new String[5];
                String[] tempArray2 = new String[5];
                boolean isNodeSetValid = false;
                boolean isPubNodeFound = false;
                int matchingNodeIndex = -1;
                String matchingNode = "";
                for (int i3 = 0; i3 < listReadFromFile.length; ++i3) {
                    isNodeSetValid = false;
                    isPubNodeFound = false;
                    if (listReadFromFile[i3] == null) {
                        listReadFromFile = new String[]{"ERROR1:" + OiQueryFileRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_EXCEPTION")};
                        return listReadFromFile;
                    }
                    tempArray1 = listReadFromFile[i3].split(":");
                    curPubNode = tempArray1[0];
                    curPrivNode = tempArray1[1];
                    for (int j = 0; j < this.currentSpreadTable.length; ++j) {
                        if (this.currentSpreadTable[j] == null) continue;
                        tempArray2 = this.currentSpreadTable[j].split(":");
                        curSpreadTablePubNode = tempArray2[0];
                        String string = curSpreadTablePrivNode = tempArray2[1] == null ? "" : tempArray2[1];
                        if (!curPubNode.equalsIgnoreCase(curSpreadTablePubNode)) continue;
                        isPubNodeFound = true;
                        matchingNode = curSpreadTablePubNode;
                        if (tempArray2[4].equalsIgnoreCase("Y")) {
                            this.currentSpreadTable[j] = tempArray1[0] + ":" + tempArray1[1] + ":" + tempArray1[2] + ":" + this.currentSpreadTable[j].split(":")[3] + ":" + this.currentSpreadTable[j].split(":")[4];
                            isNodeSetValid = true;
                            break;
                        }
                        if (!curPrivNode.equalsIgnoreCase(curSpreadTablePrivNode)) break;
                        isNodeSetValid = true;
                        break;
                    }
                    if (isPubNodeFound && isNodeSetValid) {
                        inValidPubNodesFromSpreadTable.removeElement(matchingNode);
                        inValidPubNodesFromFile.removeElement(matchingNode);
                    }
                    if (!isPubNodeFound || isNodeSetValid) continue;
                    inValidPubNodesFromFile.removeElement(matchingNode);
                    inValidPubNodesFromSpreadTable.removeElement(matchingNode);
                    inValidNodeVector.add(idx++, "20010:" + tempArray2[0]);
                }
                if (!comboCase && inValidPubNodesFromFile.size() > 0) {
                    counter = inValidNodeVector.size();
                    for (i2 = 0; i2 < inValidPubNodesFromSpreadTable.size(); ++i2) {
                        inValidNodeVector.add(counter++, "20009:" + inValidPubNodesFromSpreadTable.elementAt(i2));
                    }
                }
                if (!comboCase && areAllNodes9i && inValidPubNodesFromFile.size() == 0 && inValidPubNodesFromSpreadTable.size() > 0) {
                    counter = inValidNodeVector.size();
                    for (i2 = 0; i2 < inValidPubNodesFromSpreadTable.size(); ++i2) {
                        inValidNodeVector.add(counter++, "20009:" + inValidPubNodesFromSpreadTable.elementAt(i2));
                    }
                }
                if (comboCase) {
                    if (inValidPubNodesFromFile.size() > 0) {
                        counter = inValidNodeVector.size();
                        for (i2 = 0; i2 < inValidPubNodesFromSpreadTable.size(); ++i2) {
                            inValidNodeVector.add(counter++, "20009:" + inValidPubNodesFromSpreadTable.elementAt(i2));
                        }
                    } else if (inValidPubNodesFromSpreadTable.size() > 0) {
                        counter = inValidNodeVector.size();
                        for (i2 = 0; i2 < inValidPubNodesFromSpreadTable.size(); ++i2) {
                            String a = (String)inValidPubNodesFromSpreadTable.elementAt(i2);
                            for (int j = 0; j < pickUp9iNodesFromSpreadTable.size(); ++j) {
                                String b = (String)pickUp9iNodesFromSpreadTable.elementAt(j);
                                if (!a.equalsIgnoreCase(b)) continue;
                                inValidNodeVector.add(counter++, "20009:" + inValidPubNodesFromSpreadTable.elementAt(i2));
                            }
                        }
                    }
                }
            }
        } else {
            if (listReadFromFile != null) {
                return listReadFromFile;
            }
            listReadFromFile = new String[]{"ERROR1:" + OiQueryFileRes.getString("OiClusterConfigFileInput_INVALID_NODE_NAMES_EXCEPTION")};
            return listReadFromFile;
        }
        if (inValidNodeVector.size() == 0) {
            return this.currentSpreadTable;
        }
        String[] errorArray = new String[inValidNodeVector.size()];
        for (int i = 0; i < inValidNodeVector.size(); ++i) {
            errorArray[i] = "ERROR2:" + inValidNodeVector.elementAt(i);
        }
        return errorArray;
    }

    public static void main(String[] args) {
    }
}

